#ifndef HEADER_LUMITRONIX_IFLEX_WORKSHOP_PULSE
#define HEADER_LUMITRONIX_IFLEX_WORKSHOP_PULSE


#include <Arduino.h>


/**
 * Renders a sine wave with defined offset and period
 */
class LUMITRONIX_iFlexWorkshop_Pulse final {
public:
	explicit LUMITRONIX_iFlexWorkshop_Pulse() {
	}

	void Begin() {
		// nop
	}

	/* @return 127.5 · sin( 2π/period · (x + offset) ) + 127.5
	 */
	uint8_t operator()(float const periodMs, float const offsetMs = 0.f) {
		constexpr static float UINT8_HALF{static_cast<float>(UINT8_MAX) / 2.f};

		return static_cast<uint8_t>(UINT8_HALF * sinf(TWO_PI / periodMs * (millis() + offsetMs)) + UINT8_HALF);
	}
};


#endif

