#ifndef HEADER_LUMITRONIX_IFLEX_WORKSHOP_POWER_SENSE
#define HEADER_LUMITRONIX_IFLEX_WORKSHOP_POWER_SENSE


#include <Arduino.h>
#include "LUMITRONIX_iFlexWorkshop_Display.h"


/**
 * Utility for external power sensing on the iFlex Workshop module in order to
 * help users troubleshooting, since the iFlex stripes need an external power
 * supply.
 */
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_POWER_SENSE_JACK_SENSE_PIN{4};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_POWER_SENSE_5V_EXT_SENSE_PIN{0};

class LUMITRONIX_iFlexWorkshop_PowerSense final {
private:
	uint8_t jackSensePin{LUMITRONIX_IFLEX_WORKSHOP_POWER_SENSE_JACK_SENSE_PIN};
	uint8_t powerSensePin{LUMITRONIX_IFLEX_WORKSHOP_POWER_SENSE_5V_EXT_SENSE_PIN};

public:
	explicit LUMITRONIX_iFlexWorkshop_PowerSense() {
	}

	void Begin() {
		::pinMode(jackSensePin, INPUT_PULLUP);
		::pinMode(powerSensePin, INPUT);
	}

	[[nodiscard]] bool IsBarrelJackPluggedIn() {
		return HIGH == ::digitalRead(jackSensePin);
	}

	[[nodiscard]] bool Is5VExtPresent() {
		auto const THRESHOLD_VALUE = static_cast<decltype(::analogRead(powerSensePin))>((2.0 / 5.0) * 1024);
		return ::analogRead(powerSensePin) > THRESHOLD_VALUE;
	}
};


#define LUMITRONIX_CHECK_EXTERNAL_POWER						\
	{									\
		if (!powerSense.IsBarrelJackPluggedIn()) {			\
			display.Set(						\
				"Barrel Jack",					\
				"unplugged"					\
			);							\
			return;							\
		}								\
										\
		if (!powerSense.Is5VExtPresent()) {				\
			display.Set(						\
				"Check PSU",					\
				"+5V-EXT missing"				\
			);							\
			return;							\
		}								\
	};									\


#endif

