#ifndef HEADER_LUMITRONIX_IFLEX_WORKSHOP_DISPLAY
#define HEADER_LUMITRONIX_IFLEX_WORKSHOP_DISPLAY


#include <Arduino.h>
#include <LiquidCrystal.h>
#include <Print.h>


/**
 * Preconfigured {@link LiquidCrystal} for use with 1700076-E11270 during the
 * iFlex Workshop.
 */
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_RS_PIN{16};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_EN_PIN{17};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D4_PIN{18};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D5_PIN{19};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D6_PIN{7};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D7_PIN{6};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_COLUMNS{16};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_ROWS{2};


class LUMITRONIX_iFlexWorkshop_Display final {
private:
	LiquidCrystal lcd;
	String oldLineOne{""};
	String oldLineTwo{""};

public:
	explicit LUMITRONIX_iFlexWorkshop_Display() : lcd{
		LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_RS_PIN,
		LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_EN_PIN,
		LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D4_PIN,
		LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D5_PIN,
		LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D6_PIN,
		LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_D7_PIN
	} {}

	void Begin() {
		lcd.begin(
			LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_COLUMNS,
			LUMITRONIX_IFLEX_WORKSHOP_DISPLAY_ROWS
		);
		lcd.clear();
	}


	/* Clears the display and prints the text while making sure to only
	 * refresh when necessary
	 */
	void Set(String const& newLineOne, String const& newLineTwo) {

		/* Skip unnecessary refreshes
		 */
		if ((oldLineOne == newLineOne) && (oldLineTwo == newLineTwo)) {
			return;
		}

		lcd.clear();

		lcd.setCursor(0, 0);
		lcd.print(newLineOne);

		lcd.setCursor(0, 1);
		lcd.print(newLineTwo);

		oldLineOne = newLineOne;
		oldLineTwo = newLineTwo;
	}

	void Set(char const* newLineOne, char const* newLineTwo) {
		Set(String{newLineOne}, String{newLineTwo});
	}

	void Set(String const& lineOne) {
		Set(lineOne, String{""});
	}

	void Set(char const* lineOne) {
		Set(lineOne, "");
	}


	/* Changes the contents of line one while keeping the contents of line
	 * two unchanged
	 */
	void SetLineOne(String const& newLineOne) {
		Set(newLineOne, oldLineTwo);
	}

	void SetLineOne(char const* newLineOne) {
		Set(String{newLineOne}, oldLineTwo);
	}


	/* Changes the contents of line tow while keeping the contents of line
	 * one unchanged
	 */
	void SetLineTwo(String const& newLineTwo) {
		Set(oldLineOne, newLineTwo);
	}

	void SetLineTwo(char const* newLineTwo) {
		Set(oldLineOne, String{newLineTwo});
	}
};


#endif

