/**
 * LUMITRONIX iFlex Workshop ‒ Chapter 3 / Animation
 *
 *     https://www.lumitronix.com/
 *     b2b@leds.de
 *
 * Source code for iFlex Workshop Chapter 3. Refer to slides/talk for details.
 *
 * This example code is in the public domain.
 */
#include <Arduino.h>
#include <LUMITRONIX_iFlexWorkshop.h>


LUMITRONIX_iFlexWorkshop_ButtonA buttonA;
LUMITRONIX_iFlexWorkshop_ButtonB buttonB;
LUMITRONIX_iFlexWorkshop_Display display;
LUMITRONIX_iFlexWorkshop_Pulse pulse;

LUMITRONIX_iFlexPro iFlexPro{
  LUMITRONIX_IFLEX_WORKSHOP_PRO_LEDS,
  LUMITRONIX_IFLEX_WORKSHOP_PRO_PIN
};


void setup() {
  buttonA.Begin();
  buttonB.Begin();
  display.Begin();
  pulse.Begin();

  iFlexPro.Begin();
}


void loop() {

  //                     LED,   R,   G,   B, W
  iFlexPro.SetPixelColor(  0,   0,   0,   0, pulse(2000.f,    0.f));
  iFlexPro.SetPixelColor(  1,   0,   0,   0, pulse(2000.f,  100.f));
  iFlexPro.SetPixelColor(  2,   0,   0,   0, pulse(2000.f,  200.f));
  iFlexPro.SetPixelColor(  3,   0,   0,   0, pulse(2000.f,  300.f));
  iFlexPro.SetPixelColor(  4,   0,   0,   0, pulse(2000.f,  400.f));
  iFlexPro.SetPixelColor(  5,   0,   0,   0, pulse(2000.f,  500.f));
  iFlexPro.SetPixelColor(  6,   0,   0,   0, pulse(2000.f,  600.f));
  iFlexPro.SetPixelColor(  7,   0,   0,   0, pulse(2000.f,  700.f));
  iFlexPro.SetPixelColor(  8,   0,   0,   0, pulse(2000.f,  800.f));
  iFlexPro.SetPixelColor(  9,   0,   0,   0, pulse(2000.f,  900.f));
  iFlexPro.SetPixelColor( 10,   0,   0,   0, pulse(2000.f, 1000.f));

  iFlexPro.Show();
}

