/**
 * LUMITRONIX iFlex Workshop ‒ Chapter 2 / Interaction
 *
 *     https://www.lumitronix.com/
 *     b2b@leds.de
 *
 * Source code for iFlex Workshop Chapter 2. Refer to slides/talk for details.
 *
 * This example code is in the public domain.
 */
#include <Arduino.h>
#include <LUMITRONIX_iFlexWorkshop.h>


LUMITRONIX_iFlexWorkshop_ButtonA buttonA;
LUMITRONIX_iFlexWorkshop_ButtonB buttonB;
LUMITRONIX_iFlexWorkshop_Display display;

LUMITRONIX_iFlexPro iFlexPro{
  LUMITRONIX_IFLEX_WORKSHOP_PRO_LEDS,
  LUMITRONIX_IFLEX_WORKSHOP_PRO_PIN
};


void setup() {
  buttonA.Begin();
  buttonB.Begin();
  display.Begin();

  iFlexPro.Begin();
}


void loop() {

  // Both button A and B → all pixel blue
  if (buttonA.IsPressed() && buttonB.IsPressed()) {
    display.Set("Blue");

    //                     LED,   R,   G,   B,   W
    iFlexPro.SetPixelColor(  0,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  1,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  2,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  3,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  4,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  5,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  6,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  7,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  8,   0,   0, 255,   0);
    iFlexPro.SetPixelColor(  9,   0,   0, 255,   0);
    iFlexPro.SetPixelColor( 10,   0,   0, 255,   0);
  }

  // Only button A → all pixel red
  else if (buttonA.IsPressed()) {
    display.Set("Red");

    //                     LED,   R,   G,   B,   W
    iFlexPro.SetPixelColor(  0, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  1, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  2, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  3, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  4, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  5, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  6, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  7, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  8, 255,   0,   0,   0);
    iFlexPro.SetPixelColor(  9, 255,   0,   0,   0);
    iFlexPro.SetPixelColor( 10, 255,   0,   0,   0);

  }

  // Only button B → all pixel green
  else if (buttonB.IsPressed()) {
    display.Set("Green");

    //                     LED,   R,   G,   B,   W
    iFlexPro.SetPixelColor(  0,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  1,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  2,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  3,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  4,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  5,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  6,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  7,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  8,   0, 255,   0,   0);
    iFlexPro.SetPixelColor(  9,   0, 255,   0,   0);
    iFlexPro.SetPixelColor( 10,   0, 255,   0,   0);
  }

  // Neither button A nor B → all pixel white
  else {
    display.Set("White");

    //                     LED,   R,   G,   B,   W
    iFlexPro.SetPixelColor(  0,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  1,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  2,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  3,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  4,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  5,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  6,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  7,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  8,   0,   0,   0, 255);
    iFlexPro.SetPixelColor(  9,   0,   0,   0, 255);
    iFlexPro.SetPixelColor( 10,   0,   0,   0, 255);
  }

  iFlexPro.Show();
}
