/**
 * LUMITRONIX iFlex Workshop ‒ Power Sense example
 *
 *     https://www.lumitronix.com/
 *     b2b@leds.de
 *
 * Demonstrates the use of the power sensing circuitry on board the iFlex
 * Workshop module to prevent common mistakes when wiring up the module.
 *
 * This sketch checks whether a plug is inserted into the barrel jack and +5V
 * is present. That information is then displayed on the LCD.
 *
 * This example code is in the public domain.
 */
#include <Arduino.h>
#include <LUMITRONIX_iFlexWorkshop.h>


LUMITRONIX_iFlexWorkshop_Display display;
LUMITRONIX_iFlexWorkshop_PowerSense powerSense;


void setup() {

  // Setup the display and power sense circuitry
  display.Begin();
  powerSense.Begin();

  display.Set("PowerSense");
}


void loop() {

  // External power supply is not plugged in
  if (!powerSense.IsBarrelJackPluggedIn()) {
    display.Set(
      "Barrel Jack",
      "unplugged"
    );

  // External power supply is plugged in, but not turned on
  //
  // @warning Due to an issue on Nano V3, the USB power is forwarded to +5V-EXT,
  //     thus this check never fails
  } else if (!powerSense.Is5VExtPresent()) {
    display.Set(
      "PowerSense",
      "+5V-EXT missing"
    );

  // Everything ok
  } else {
    display.Set(
      "PowerSense",
      "+5V-EXT OK"
    );
  }
}
