/**
 * LUMITRONIX iFlex Workshop ‒ Button example
 *
 *     https://www.lumitronix.com/
 *     b2b@leds.de
 *
 * Demonstrates the use of the two push buttons mounted on the iFlex Workshop
 * module.
 *
 * This sketch polls and prints the button states to the LCD display.
 *
 * This example code is in the public domain.
 */
#include <Arduino.h>
#include <LUMITRONIX_iFlexWorkshop.h>


LUMITRONIX_iFlexWorkshop_ButtonA buttonA;
LUMITRONIX_iFlexWorkshop_ButtonB buttonB;
LUMITRONIX_iFlexWorkshop_Display display;


void setup() {

  // Setup buttons and display
  buttonA.Begin();
  buttonB.Begin();
  display.Begin();
}


void loop() {

  // Is button A currently pressed?
  if (buttonA.IsPressed()) {
    display.SetLineOne("Btn A pressed");
  }

  // Is button A currently released?
  //
  // This is mutally exclusive with the condition above
  if (buttonA.IsReleased()) {
    display.SetLineOne("Btn A released");
  }

  // Is button B currently pressed?
  if (buttonB.IsPressed()) {
    display.SetLineTwo("Btn B pressed");
  }

  // Is button B currently released?
  //
  // This is mutally exclusive with the condition above
  if (buttonB.IsReleased()) {
    display.SetLineTwo("Btn B released");
  }
}
