/**
 * LUMITRONIX iFlex Workshop ‒ Are you ready?
 *
 *     https://www.lumitronix.com/
 *     b2b@leds.de
 *
 * Usage:
 *
 *  1) Use the ✓-Button on the top left to verify this sketch
 *    - You should see a "Done compiling." message in the status bar on the
 *      bottom
 *  2) Use the ➞-Button on the top left ‒ right next to the ✓-Button ‒ to
 *     upload the sketch to the Nano V3 connected via USB
 *    - You should see a "Done uploading." message in the status bar on the
 *      bottom
 *    - Your iFlex Devboard should display a "You are ready!" message on the LCD
 *    - Your iFlex Pro Stripe should pulse in green
 *
 * Troubleshooting
 *  - Make sure your computer is connected to the Nano V3 via an USB cable
 *  - Make sure the corrent port is selected at Tools / Port. It might be
 *    necessary to try multiple if you are unsure which is the correct one
 *  - Make sure the external power supply is plugged into both the wall outlet
 *    and the iFlex Devboard
 *
 * This example code is in the public domain.
 */
#include <Arduino.h>
#include <LUMITRONIX_iFlexWorkshop.h>


LUMITRONIX_iFlexWorkshop_Display display;
LUMITRONIX_iFlexWorkshop_PowerSense powerSense;
LUMITRONIX_iFlexWorkshop_Pulse pulse;


LUMITRONIX_iFlexPro iFlexPro{
  LUMITRONIX_IFLEX_WORKSHOP_PRO_LEDS,
  LUMITRONIX_IFLEX_WORKSHOP_PRO_PIN
};


void setup() {
  display.Begin();
  powerSense.Begin();
  pulse.Begin();

  iFlexPro.Begin();
}


void loop() {

  // Check external power is plugged in
  LUMITRONIX_CHECK_EXTERNAL_POWER;

  // Display success message and number of seconds since reset
  display.Set(
    String{"You are ready!"},
    String{"Time: "} + String{::millis() / 1000, DEC}
  );

  // Pulse green LED while shining white
  //
  //                     LED,   R,             G,   B,   W
  iFlexPro.SetPixelColor(  0,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  1,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  2,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  3,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  4,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  5,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  6,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  7,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  8,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor(  9,   0, pulse(2000.f),   0, 128);
  iFlexPro.SetPixelColor( 10,   0, pulse(2000.f),   0, 128);
  
  iFlexPro.Show();
}

