#ifndef HEADER_LUMITRONIX_IFLEX_WORKSHOP_PRO
#define HEADER_LUMITRONIX_IFLEX_WORKSHOP_PRO


#include "LumitronixIFlexBusLg.h"


static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_ECO_LEDS{300};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_ECO_PIN{0};

static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_PRO_LEDS{11};
static constexpr auto LUMITRONIX_IFLEX_WORKSHOP_PRO_PIN{2};


class LUMITRONIX_iFlexPro final : public LumitronixIFlexBusLg<NeoWrgbTm1814Feature, NeoTm1814InvertedMethod> {
public:
	explicit LUMITRONIX_iFlexPro(uint16_t leds, uint8_t pin) : LumitronixIFlexBusLg<NeoWrgbTm1814Feature, NeoTm1814InvertedMethod>{leds, pin} {
	}

	/* @warning The upstream sources need to be patched to make `Begin'
	 *     `virtual', otherwise the `final override' does not work and we
	 *     would need to rely on shadowing
	 */
	void Begin() final override {

		/* @warning While no individual channel needs to be limited, the
		 *     thermal design target of the RGB chip is limited and thus
		 *     the user must take care not to exceed the total power of
		 *     the RGB channels!
		 *
		 * @see iFlex Pro datasheet for details and derating details
		 */
		SetPixelSettings(NeoTm1814Settings{
			NeoTm1814Settings::MaxCurrent,
			NeoTm1814Settings::MaxCurrent,
			NeoTm1814Settings::MaxCurrent,
			NeoTm1814Settings::MaxCurrent
		});

		LumitronixIFlexBusLg<NeoWrgbTm1814Feature, NeoTm1814InvertedMethod>::Begin();
	}

	void SetPixelColor(uint16_t led, uint8_t red, uint8_t green, uint8_t blue, uint8_t white) {
		SetPixelColor(led, RgbwColor{red, green, blue, white});
	}

	void SetPixelColor(uint16_t indexPixel, typename NeoWrgbTm1814Feature::ColorObject color) /*override*/ {
		LumitronixIFlexBusLg<NeoWrgbTm1814Feature, NeoTm1814InvertedMethod>::SetPixelColor(indexPixel, color);
	}
};


#endif

