/**
 * LUMITRONIX iFlex Workshop ‒ Display example
 *
 *     https://www.lumitronix.com/
 *     b2b@leds.de
 *
 * Demonstrates the use of the 16x2 LCD display mounted on the iFlex Workshop
 * module.
 *
 * This sketch prints "Hello World!" to the LCD and shows the time.
 *
 * This example code is in the public domain, based upon LiquidCrystal Library
 */
#include <Arduino.h>
#include <LUMITRONIX_iFlexWorkshop.h>


LUMITRONIX_iFlexWorkshop_Display display;


void setup() {

  // Setup the display
  display.Begin();

  // Print a message to the display.
  display.Set("Hello, World!");
}


void loop() {

  // Print the number of seconds since reset one line two
  display.SetLineTwo(String{"Time: "} + String{::millis() / 1000});
}

